



<html>
<head>
  <title>javabog.dk -  - Objektorienteret analyse og design</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel21.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel23.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">22 <a name='afsn22'></a>Objektorienteret
analyse og design</H1>
<P CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI><P CLASS="kapiteloversigt-western">Analyse: Finde vigtige ord,
  brugssituationer, aktivitetsdiagrammer og sk&aelig;rmbilleder</P>
  <LI><P CLASS="kapiteloversigt-western">Design:
  Kollaborationsdiagrammer og klassediagrammer</P>
  <LI><P CLASS="kapiteloversigt-western">Eksempel: Skitse til et
  yatzy-spil</P>
</UL>
<P CLASS="kapiteloversigt-western">Kapitlet giver id&eacute;er til,
hvordan en problemstilling kan analyseres, f&oslash;r man g&aring;r i
gang med at  programmere.</P>
<P CLASS="kapiteloversigt-western">Foruds&aelig;tter <a href='kapitel5.jsp'>kapitel 5</a>, Nedarvning.</P>


<P CLASS="western" STYLE="">N&aring;r et
program udvikles, sker det normalt i fem faser:</P>
<OL>
  <LI><P CLASS="western">Kravene til programmet bliver afd&aelig;kket.</P>
  <LI><P CLASS="western">Analyse - hvad det er for ting og begreber,
  programmet handler om.</P>
  <LI><P CLASS="western">Design - hvordan programmet skal laves.</P>
  <LI><P CLASS="western">Programmering.</P>
  <LI><P CLASS="western">Afpr&oslash;vning.</P>
</OL>
<P CLASS="western">I traditionel systemudvikling er idealet, at de
fem faser udf&oslash;res en efter en, s&aring;dan at en ny fase f&oslash;rst
p&aring;begyndes, n&aring;r den forrige er afsluttet. Hver fase
udm&oslash;ntes i et dokument, som senere kan bruges til
dokumentation af systemet.</P>
<P CLASS="western">Dette er i skarp mods&aelig;tning til den m&aring;de,
som en selvl&aelig;rt umiddelbart ville programmere. Her blandes
faserne sammen i hovedet p&aring; programm&oslash;ren, som skifter
mellem dem, mens han programmerer. Resultatet er ofte et program, der
b&aelig;rer pr&aelig;g af ad-hoc-udbygninger og som er sv&aelig;rt
at overskue og vedligeholde - selv for programm&oslash;ren selv<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>.</P>
<P CLASS="western">Den bedste udviklingsmetode findes nok et sted
mellem de to ekstremer. Der dukker f.eks. altid nye ting op under
programmeringen, som g&oslash;r, at man m&aring; &aelig;ndre sit
design. Omvendt er det sv&aelig;rt at programmere uden et gennemt&aelig;nkt
design.</P>
<P CLASS="western">Derfor er det ikke en god ide at bruge alt for
lang tid p&aring; at lave fine tegninger og diagrammer - en
blyantskitse er lige s&aring; god. Det er indholdet, der t&aelig;ller,
og ofte laver man om i sit design flere gange, inden programmet er
f&aelig;rdigt. Dette g&aelig;lder is&aelig;r, hvis man er i gang med
at l&aelig;re at programmere.</P>
<P CLASS="western">Dette kapitel viser gennem et eksempel (et
Yatzy-spil) en grov skitse til objektorienteret analyse og design
(forkortet OOAD). Det er t&aelig;nkt som inspiration til, hvordan man
kunne gribe sit eget projekt an, ved at f&oslash;lge de samme trin.</P>
<H2 CLASS="western">22.1 <a name='afsn22.1'></a>Krav til programmet</SPAN></H2>
<P CLASS="western">Vi skal lave et Yatzy-spil for flere spillere. Der
kan v&aelig;re et variabelt antal spillere, hvoraf nogle kan v&aelig;re
styret af computeren. Computerspillerne skal have forskellige
strategier (dum/tilf&aelig;ldig, gr&aring;dig, strategisk), der
v&aelig;lges tilf&aelig;ldigt.</P>
<P CLASS="western">Efter at spillet er afsluttet, huskes resultatet i
et lager, hvorfra man kan generere en hiscore-liste.</P>
<H2 CLASS="western" STYLE="">22.2 <a name='afsn22.2'></a>Objektorienteret
analyse</SPAN></H2>
<P CLASS="western">Analysen skal beskrive, <SPAN STYLE="font-weight: medium">hvad</SPAN>
det er for ting og begreber, programmet handler om. Analyse-fasens
form&aring;l er, at afspejle virkeligheden mest muligt.</P>
<H3 CLASS="western">22.2.1 <a name='afsn22.2.1'></a>Skrive vigtige ord op</H3>
<P CLASS="western">Det kan v&aelig;re en hj&aelig;lp f&oslash;rst at
skrive alle de navneord (i ental) eller ting op, man kan komme i
tanke om ved problemet. Ud for hver ting kan man notere eventuelle
egenskaber (ofte till&aelig;gsord) og handlinger (ofte udsagnsord),
der knytter sig til tingen.</P>
<UL>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Yatzyspil
  - antal spillere</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Terning
  - v&aelig;rdi, kaste, holde</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Rafleb&aelig;ger
  - kombination, ryste, holde</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Blok
  - skrive spillernavn p&aring;, skrive point p&aring;</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Spiller
  - navn, type (computer/menneske)</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Computerspiller
  - strategi (dum/tilf&aelig;ldig, gr&aring;dig, strategisk)</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Menneskespiller</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Regel
  (kunne ogs&aring; kaldes en mulighed eller et kriterium) - opfyldt,
  brugt, antal point</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Lager
  - hiscore</P>
</UL>
<H3 CLASS="western">22.2.2 <a name='afsn22.2.2'></a>Brugssituationer</H3>
<P CLASS="western">Brugssituationer (eng.: Use Case) beskriver en
samling af akt&oslash;rer og hvilke brugssituationer de deltager i.
Man starter helt overordnet og g&aring;r mere og mere i detaljer
omkring hver brugssituation.</P>
<P CLASS="western">Man kan h&aelig;vde, at Yatzy-spillet er p&aring;
gr&aelig;nsen til at v&aelig;re for simpelt til at lave
brugsm&oslash;nstre. Herunder to brugssituationer. Til venstre
ses et meget overordnet, der beskriver to spillere og lageret som
akt&oslash;rer. Til h&oslash;jre ses brugssituationen omkring en tur.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog23_html_m66ca036e.gif" NAME="Objekt31" ALIGN=MIDDLE>
    
<IMG SRC="bog23_html_7d275d86.gif" NAME="Objekt32" ALIGN=MIDDLE></P>

<P CLASS="western">I stedet for at tegne flotte diagrammer kan man
ogs&aring; blot beskrive hver brugssituation med almindelig tekst.</P>

<H3 CLASS="western" STYLE="">22.2.3 <a name='afsn22.2.3'></a>Aktivitetsdiagrammer</H3>
<P CLASS="western">Aktivitetsdiagrammer beskriver den r&aelig;kkef&oslash;lge,
som adf&aelig;rdsm&oslash;nstre og aktiviteter foreg&aring;r i.
Eksempel: Aktiviteten &quot;definere deltagere i spillet&quot;:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog23_html_m1e1b7566.gif" NAME="Objekt33" ALIGN=BOTTOM></P>

<P CLASS="western">Herunder ses et diagram for spillets gang, &quot;en
tur&quot;:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog23_html_19019d9d.gif" NAME="Objekt34" ALIGN=BOTTOM></P>

<H3 CLASS="western">22.2.4 <a name='afsn22.2.4'></a>Sk&aelig;rmbilleder</H3>
<P CLASS="western">Hvis sk&aelig;rmbilleder er en v&aelig;sentlig del
af ens program, er det en god hj&aelig;lp at tegne de v&aelig;sentligste,
for at g&oslash;re sig klart, hvilke elementer programmet skal
indeholde. 
</P>
<P CLASS="western">Disse kan med fordel designes direkte med et
Java-udviklingsv&aelig;rkt&oslash;j. Herved opn&aring;r man en ide
om, hvad der er muligt, samtidig med at den genererede kode ofte (men
ikke altid!) kan genbruges i programmeringsfasen. 
</P>
<P CLASS="western">Normalt kommer der en klasse for hvert
sk&aelig;rmbillede, s&aring; man kan ogs&aring; med det samme give
dem sigende navne.</P>

<P CLASS="western" STYLE="">N&aring;r
programmet startes, skal v&aelig;lges 2-6 spillere, hvoraf nogle kan
v&aelig;re computerspillere:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog23_html_m7c7f4d6d.gif" NAME="Objekt35" ALIGN=BOTTOM></P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>TilfoejSpillervindue</I></FONT></P>

<P CLASS="western">Under selve spillet skiftes spillerne til at f&aring;
tur. 
</P>
<P CLASS="western">For menneske-spillerne dukker dette billede op:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog23_html_m148f07ec.gif" NAME="Objekt36" ALIGN=BOTTOM></P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Turvindue</I></FONT></P>

<P CLASS="western">Man kan holde p&aring; terningerne ved at klikke
p&aring; afkrydsningsfelterne.</P>
<P CLASS="western">N&aring;r spilleren er f&aelig;rdig (efter max 3
kast), skal han/hun v&aelig;lge, hvilken regel der skal bruges,
ved at klikke p&aring; den i blok-vinduet:</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><IMG SRC="bog23_html_6878c8f3.gif" NAME="Objekt37" ALIGN=BOTTOM></P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>Blokvindue</I></FONT></P>

<H2 CLASS="western">22.3 <a name='afsn22.3'></a>Objektorienteret design</SPAN></H2>
<P CLASS="western">Designets form&aring;l er at beskrive, hvordan
programmet skal implementeres. 
</P>
<P CLASS="western">I denne fase skal man bl.a. identificere de
vigtigste klasser i systemet og lede efter ligheder mellem dem med
henblik p&aring; nedarvning og genbrug. 
</P>
<H3 CLASS="western">22.3.1 <a name='afsn22.3.1'></a>Design af klasser</H3>
<P CLASS="western">Et udgangspunkt for, hvordan man designer
klasserne og objekterne i sit program, er at objekterne i programmet
skal svare nogenlunde til de virkelige, oftest fysiske objekter fra
problemstillingen.</P>
<BLOCKQUOTE CLASS="definition-western">Navneord (substantiver) i
ental bliver ofte til klasser</BLOCKQUOTE>
<BLOCKQUOTE CLASS="definition-western">Klassenavne skal altid v&aelig;re
i ental</BLOCKQUOTE>
<BLOCKQUOTE CLASS="definition-western">Udsagnsord (verber) bliver
ofte til metoder</BLOCKQUOTE>
<P CLASS="western">Det er vigtigt at huske, at dette kun er
tommelfingerregler, som man ikke kan tage alt for bogstaveligt. Man
bliver ofte n&oslash;dt til at dreje tankegangen lidt for at f&aring;
den til at passe i sit eget program.</P>
<P CLASS="western">F.eks. er en blyant eller et andet skriveredskab
uundv&aelig;rlig i et virkeligt, fysisk Yatzy-spil (ellers kan man
ikke skrive p&aring; blokken), men ingen erfarne programm&oslash;rer
kunne dr&oslash;mme om at lave en Blyant-klasse og oprette
Blyant-objekter, da blyanter slet ikke er vigtige for logikken i
spillet.</P>

<H3 CLASS="western">22.3.2 <a name='afsn22.3.2'></a>Kollaborationsdiagrammer</H3>
<P CLASS="western">Nyttige diagramformer under design er
kollaborationsdiagrammer (samarbejdsdiagrammer), hvor man
beskriver relationerne mellem klasserne eller objekterne p&aring; et
overordnet plan. 
</P>
<P CLASS="western">Her er et eksempel:</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog23_html_m2f0ff21.gif" NAME="Objekt38" ALIGN=MIDDLE></P>

<P CLASS="western" STYLE="">Har-relationer
giver et vink om, at et objekt har en reference til (evt. ejer) et
andet objekt. F.eks.:</P>
<UL>
  <LI><P CLASS="western">Rafleb&aelig;geret har en reference til
  terningerne, ellers kan det ikke kaste dem. Terningerne kender
  ikke til rafleb&aelig;gerets eksistens.</P>
  <LI><P CLASS="western">Blokken har nogle regler (en for hver r&aelig;kke).
  Reglerne kender ikke til blokkens eller spillerens eksistens.</P>
  <LI><P CLASS="western">Blokken har nogle spillere (en for hver
  s&oslash;jle). Spillerne ved, de h&oslash;rer til en blok, hvor
  deres resultater skal skrives ind p&aring;.</P>
  <LI><P CLASS="western">Blokkens data skal vises i et vindue. Der er
  brug for, at blokken kender til Blokvindue, vinduet, der viser
  blokken p&aring; sk&aelig;rmen, s&aring; det kan gentegnes, n&aring;r
  blokken &aelig;ndrer sig. Men vinduet har ogs&aring; brug for at
  kende til blokken, som indeholder de data, det skal vise.</P>
</UL>
<P CLASS="western">N&aring;r spilleren tjekker regler, sker det
gennem blok-objektet. Man kan forestille sig, at spilleren l&oslash;ber
gennem alle blokkens regler og ser, om der er nogle, der passer, som
han ikke har brugt endnu. Tjek af regler er alts&aring; ikke en
har-relation, for spilleren har ikke en variabel, der refererer
til reglerne.</P>
<P CLASS="western">Visse steder er der mange slags objekter, der kan
indg&aring; i samme rolle. Det g&aelig;lder for eksempel Spiller
i diagrammet ovenfor. S&aring; kan man tegne et separat diagram, der
viser rollerne.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog23_html_m3e0a73d1.gif" NAME="Objekt39"></P>
<P CLASS="western">Er-en-relationer angiver generalisering eller
specialisering (hvor nedarvning kan v&aelig;re en fordel). Det tegnes
oftest med en hul pil. 
</P>
<P CLASS="western">Her er det lidt specielle, at &eacute;n type
spiller (nemlig Menneske) har et vindue tilknyttet. Dette vindue
skal jo have <SPAN STYLE="font-weight: medium"><SPAN STYLE="text-decoration: none"><SPAN STYLE="font-style: normal">adgang</SPAN></SPAN></SPAN>
til at vise terningerne, s&aring; man skal huske at s&oslash;rge for,
at spillere har en reference til rafleb&aelig;geret.</P>

<H3 CLASS="western">22.3.3 <a name='afsn22.3.3'></a>Klassediagrammer</H3>
<P CLASS="western">Herefter kan skitseres klassediagrammer, hvor man
fastl&aelig;gger nedarvning (er-en-relationerne), de vigtigste
variabler og referencerne mellem objekterne (har-relationer) og de
vigtigste metoder. 
</P>
<P CLASS="western">Dette kan eventuelt tegnes med et
UML-udviklingsv&aelig;rkt&oslash;j (f.eks. k&oslash;beudgaven af
JBuilder eller TogetherJ, der kan hentes i en gratis pr&oslash;veudgave
p&aring; <A CLASS="western" HREF="http://www.togethersoft.com/">http://www.togethersoft.com</A>
), der samtidig kan generere kode til programmeringsfasen.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog23_html_1de3be81.png" NAME="Grafik22" ALIGN=BOTTOM BORDER=0></P>

<P CLASS="western">Herunder ses, hvilke typer regler, der kunne
forekomme.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog23_html_1678a044.png" NAME="Grafik23" ALIGN=BOTTOM BORDER=0></P>

<H1 CLASS="heading1a-western" STYLE="">Engelsk-dansk
ordliste</H1>
<TABLE BORDER=22 <a name='afsn22'></a>CELLPADDING=4 CELLSPACING=0>
  <COL>
  <COL>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">access 
      </P>
    </TD>
    <TD>
      <P CLASS="western">adgang, tilgang</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">applet 
      </P>
    </TD>
    <TD>
      <P CLASS="western">applet<BR>miniprogram der kan k&oslash;re i en
      netl&aelig;ser, f.eks. Netscape</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">array 
      </P>
    </TD>
    <TD>
      <P CLASS="western">tabel, r&aelig;kke, array 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">assignment 
      </P>
    </TD>
    <TD>
      <P CLASS="western">tildeling <BR>a=5; er en tildeling af v&aelig;rdien
      5 til variablen a</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">backslash</P>
    </TD>
    <TD>
      <P CLASS="western">bagstreg ( \ - angives som '\\' i kildeteksten)</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">backspace</P>
    </TD>
    <TD>
      <P CLASS="western">bak-tegnet ('\b')</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">block (statement)</P>
    </TD>
    <TD>
      <P CLASS="western">blok<BR>en gruppering af kommandoer. Starter
      med { og slutter med }</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">boolean</P>
    </TD>
    <TD>
      <P CLASS="western">logisk (boolsk) v&aelig;rdi<BR>sand (true)
      eller falsk (false). 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">browser</P>
    </TD>
    <TD>
      <P CLASS="western">netl&aelig;ser (f.eks. Netscape, Opera eller
      Internet Explorer)</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">bytecode 
      </P>
    </TD>
    <TD>
      <P CLASS="western">mellemkode<BR>bin&aelig;r kode i en .class-fil,
      genereret af Java-overs&aelig;tteren fra en .java-kildetekst. 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">carriage return</P>
    </TD>
    <TD>
      <P CLASS="western">vognretur ('\r')</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">cast 
      </P>
    </TD>
    <TD>
      <P CLASS="western">typekonvertering <BR>f.eks a = (int) f;
      konverterer v&aelig;rdien af f til et heltal f&oslash;r det
      tildeles a 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">character</P>
    </TD>
    <TD>
      <P CLASS="western">tegn <BR>f.eks 'b', '9', '?' 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">character set 
      </P>
    </TD>
    <TD>
      <P CLASS="western">tegns&aelig;t 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">checked exception</P>
    </TD>
    <TD>
      <P CLASS="western">undtagelse med tvungen h&aring;ndtering</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">class</P>
    </TD>
    <TD>
      <P CLASS="western">klasse <BR>beskrivelsen af en objekttype 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">comment 
      </P>
    </TD>
    <TD>
      <P CLASS="western">kommentar <BR>tekst der forklarer programmet.
      Ignoreres af maskinen. <BR>En linje der starter med // bliver
      opfattet som en kommentar 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">compiler 
      </P>
    </TD>
    <TD>
      <P CLASS="western">overs&aelig;tter <BR>f.eks fra Java-kildetekst
      til bytekode</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">concatenation 
      </P>
    </TD>
    <TD>
      <P CLASS="western">sammens&aelig;tning (af tegnstrenge) <BR>f.eks
      &quot;Hej &quot; + &quot;verden&quot; sammens&aelig;tter to
      strenge 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">condition 
      </P>
    </TD>
    <TD>
      <P CLASS="western">betingelse <BR>a&gt;5 er betingelsen i
      s&aelig;tningen:<BR>if (a&gt;5) System.out.println(&quot;a er 6
      eller derover&quot;);</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">constructor</P>
    </TD>
    <TD>
      <P CLASS="western">konstrukt&oslash;r</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">debugging</P>
    </TD>
    <TD>
      <P CLASS="western">fejlfinding/aflusning af et program<BR>f.eks
      med trinvis gennemgang 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">declaration</P>
    </TD>
    <TD>
      <P CLASS="western">erkl&aelig;ring <BR>int a; er en erkl&aelig;ring
      af, at a er et heltal. 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">decrement 
      </P>
    </TD>
    <TD>
      <P CLASS="western">nedt&aelig;lling</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">deprecated</P>
    </TD>
    <TD>
      <P CLASS="western">frar&aring;det, for&aelig;ldet</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">digit</P>
    </TD>
    <TD>
      <P CLASS="western">ciffer</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">encapsulation 
      </P>
    </TD>
    <TD>
      <P CLASS="western">indkapsling</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">enumeration</P>
    </TD>
    <TD>
      <P CLASS="western">opremsning (af nogle elementer)</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">event 
      </P>
    </TD>
    <TD>
      <P CLASS="western">h&aelig;ndelse</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">event driven 
      </P>
    </TD>
    <TD>
      <P CLASS="western">h&aelig;ndelsesstyret</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">exception 
      </P>
    </TD>
    <TD>
      <P CLASS="western">undtagelse</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">expression 
      </P>
    </TD>
    <TD>
      <P CLASS="western">udtryk<BR>f.eks (a*5)/7 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">file 
      </P>
    </TD>
    <TD>
      <P CLASS="western">fil 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">floating-point number 
      </P>
    </TD>
    <TD>
      <P CLASS="western">kommatal<BR>i Java er kommatalstyperne float og
      double. 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">graphical user interface</P>
    </TD>
    <TD>
      <P CLASS="western">grafisk brugergr&aelig;nseflade 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">hardware 
      </P>
    </TD>
    <TD>
      <P CLASS="western">maskinel</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">host</P>
    </TD>
    <TD>
      <P CLASS="western">v&aelig;rtsmaskine</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">identifier 
      </P>
    </TD>
    <TD>
      <P CLASS="western">navn <BR>f.eks a, public, class, int 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">increment 
      </P>
    </TD>
    <TD>
      <P CLASS="western">opt&aelig;lling 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">indentation 
      </P>
    </TD>
    <TD>
      <P CLASS="western">indrykning 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">inheritance 
      </P>
    </TD>
    <TD>
      <P CLASS="western">nedarvning 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">instance 
      </P>
    </TD>
    <TD>
      <P CLASS="western">instans, forekomst <BR>en forekomst af en
      klasse er et objekt, f.eks er &quot;Hej&quot; en forekomst af
      String</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">integer</P>
    </TD>
    <TD>
      <P CLASS="western">heltal <BR>i Java er heltalstyperne int, long,
      short og byte. 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">interface 
      </P>
    </TD>
    <TD>
      <P CLASS="western">gr&aelig;nseflade 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">interpreter 
      </P>
    </TD>
    <TD>
      <P CLASS="western">fortolker</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">label 
      </P>
    </TD>
    <TD>
      <P CLASS="western">etikette</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">library 
      </P>
    </TD>
    <TD>
      <P CLASS="western">bibliotek 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">listener</P>
    </TD>
    <TD>
      <P CLASS="western">lytter (efter h&aelig;ndelser)</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">location (in memory) 
      </P>
    </TD>
    <TD>
      <P CLASS="western">plads (i lager) 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">loop 
      </P>
    </TD>
    <TD>
      <P CLASS="western">l&oslash;kke 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">memory 
      </P>
    </TD>
    <TD>
      <P CLASS="western">lager 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">method 
      </P>
    </TD>
    <TD>
      <P CLASS="western">metode <BR>f.eks har System.out metoden
      println()</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">nested</P>
    </TD>
    <TD>
      <P CLASS="western">indlejret 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">newline 
      </P>
    </TD>
    <TD>
      <P CLASS="western">linjeskift ('\n')</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">open source</P>
    </TD>
    <TD>
      <P CLASS="western">&aring;ben kildekode/kildetekst<BR>at
      kildeteksten er frit tilg&aelig;ngelig for forbedringer</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">overloading</P>
    </TD>
    <TD>
      <P CLASS="western">overl&aelig;sning, navnesammenfald af metoder</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">override</P>
    </TD>
    <TD>
      <P CLASS="western">tilsides&aelig;tte/omdefinere/overstyre/overskrive
      metode i en nedarvet klasse 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">package 
      </P>
    </TD>
    <TD>
      <P CLASS="western">pakke</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">parse</P>
    </TD>
    <TD>
      <P CLASS="western">analysere, fortolke</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">pointer 
      </P>
    </TD>
    <TD>
      <P CLASS="western">reference/peger/h&aelig;gte til et objekt et
      sted i lageret</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">polymorphism</P>
    </TD>
    <TD>
      <P CLASS="western">polymorfi</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">reference 
      </P>
    </TD>
    <TD>
      <P CLASS="western">reference/peger/h&aelig;gte til et objekt et
      sted i lageret</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">rounding</P>
    </TD>
    <TD>
      <P CLASS="western">afrunding 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">scope 
      </P>
    </TD>
    <TD>
      <P CLASS="western">virkefelt</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">service</P>
    </TD>
    <TD>
      <P CLASS="western">tjeneste</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">software 
      </P>
    </TD>
    <TD>
      <P CLASS="western">programmel</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">source code</P>
    </TD>
    <TD>
      <P CLASS="western">kildetekst, kildekode</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">statement 
      </P>
    </TD>
    <TD>
      <P CLASS="western">s&aelig;tning, ordre, kommando<BR>f.eks
      System.out.println(&quot;Hej&quot;); eller a = 5; 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">stack trace</P>
    </TD>
    <TD>
      <P CLASS="western">stakspor</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">stream 
      </P>
    </TD>
    <TD>
      <P CLASS="western">str&oslash;m 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">string</P>
    </TD>
    <TD>
      <P CLASS="western">tekststreng 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">subclass 
      </P>
    </TD>
    <TD>
      <P CLASS="western">underklasse, subklasse, afledt klasse, nedarvet
      klasse</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">test 
      </P>
    </TD>
    <TD>
      <P CLASS="western">afpr&oslash;vning 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">thread 
      </P>
    </TD>
    <TD>
      <P CLASS="western">tr&aring;d</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">token 
      </P>
    </TD>
    <TD>
      <P CLASS="western">brik, bid</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">truncation</P>
    </TD>
    <TD>
      <P CLASS="western">nedrunding (3.7 bliver rundet ned til 3.0)</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">typecast 
      </P>
    </TD>
    <TD>
      <P CLASS="western">typekonvertering <BR>f.eks a = (int) f;
      konverterer v&aelig;rdien af f til et heltal f&oslash;r det
      tildeles a 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">underscore 
      </P>
    </TD>
    <TD>
      <P CLASS="western">understreg ('_' )</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">unchecked exception</P>
    </TD>
    <TD>
      <P CLASS="western">undtagelse uden tvungen h&aring;ndtering</P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">variable</P>
    </TD>
    <TD>
      <P CLASS="western">variabel 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">visibility 
      </P>
    </TD>
    <TD>
      <P CLASS="western">synlighed 
      </P>
    </TD>
  </TR>
  <TR VALIGN=TOP>
    <TD>
      <P CLASS="western">whitespace 
      </P>
    </TD>
    <TD>
      <P CLASS="western">blanktegn<BR>mellemrum, tabulatortegn og
      linjeskift er blanktegn</P>
    </TD>
  </TR>
</TABLE>



<H1 CLASS="heading1a-western" STYLE="">Stikordsregister</H1>
<MULTICOL ID="Alphabetical Index1" COLS=2 GUTTER=22 <a name='afsn22'></a>STYLE="background: transparent">
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>A</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">abstract
   292</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">abstrakte
  klasser  247, 292</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ActionListener
   224, 226</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">actionPerformed()
   196, 224, 226</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">adaptere
   228</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">addElement()
   81, 93</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">adgang
  til metoder/variabler  154</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">adgangskontrol
   154</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">AffineTransform
   185</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">afkrydsningsfelter
   198</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">afledt
  klasse  125</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">after()
   92</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">aktivitetsdiagrammer
   306</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">akt&oslash;r
   305</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">alternativudtryk
   63</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">analyse
   305</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">AND
   57</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">anf&oslash;relsestegn
   91</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">animationer
   182</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">anonyme
  klasser  228, 298</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">antialias
   184</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">apostrof
   91</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">append()
   94</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Applet
   189</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">argumenter
   71</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ArithmeticException
   231</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">aritmetiske
  operatorer  56</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">array
   166</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">array
  versus Vector  169</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ArrayIndexOutOfBoundsException
   166, 230</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ArrayList
   80, 93, 140, 169</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">arv
   124, 217</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">associative
  afbildninger  97</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">AudioClip
   189</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">auto-commit
   288</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">autoboxing
   93, 96</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">AWT-komponenter
   207</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>B</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">baggrundsfarve
   177, 198</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">bagstreg
   91</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">bak
   91</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">bankkonto
   122</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">BasicStroke
   186</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">basisklasse
   125</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">before()
   92</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">beregning
  af formel  162</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">beregningsudtryk
   34</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">betinget
  udf&oslash;relse  39</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">bin&aelig;r
  l&aelig;sning og skrivning  246</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">bin&aelig;re
  talsystem  244</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">bin&aelig;rt
  til tegnbaseret  249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">blinkeri
   183</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">blok
   42, 117</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">BlueJ
   27, 119</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Boks
   100, 103, 105, 111, 141, 156, 240</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">boolean
   55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">boolesk
  variabel  38</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">booleske
  udtryk  40</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">BorderLayout
   203</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Borland
  JBuilder  23</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">break
   64</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">browser
   188</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">brugergr&aelig;nseflade
   194</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">brugssituationer
   305</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">buffer
   246</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">BufferedReader
   243, 249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Button
   198, 225</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">byte
   55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ByteArrayInputStream
   249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">bytekode
   21, 32</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>C</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">CallableStatement
   289</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Canvas
   200</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">catch
   231, 238</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">char
   55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Character.isDigit()
   157</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Character.isLetter()
   158</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Character.isLowerCase()
   158</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">CharArrayReader
   249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Checkbox
   198</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Checked-filtreringsklasser
   249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">checksum
   249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Choice
   198</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ClassCastException
   131, 231</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ClassNotFoundException
   233</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">CLASSPATH
   151</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">clone()
   276</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">close()
   242, 251</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">CODEBASE
   189, 192</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">commit
   288</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Comparator
   214</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ComponentListener
   226</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Connection
   284</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">containere
   202</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">continue
   64</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">cosinus
   37</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">createStatement()
   284</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Cursor
   177</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm; ">
  <FONT FACE="Helvetica, sans-serif"><B>D</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">database
   284</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">databasedriver
   284, 289</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">DatabaseMetaData
   290</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">datakompression
   250</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">datastr&oslash;mme
   242, 247</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Date
   85, 92</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">dekoration
   174</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">design
  af klasser  308</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">design-fane
   194</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">destroy()
   190</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Dialog
   202</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">dialog-boks
   202</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">division
   35</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">do-while-l&oslash;kken
   63</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">double
   35, 55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">double
  buffering  184, 207</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Double.parseDouble()
   157, 244</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">drawImage
   176</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">drawImage()
   175</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">drawLine()
   175</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">drawString
   174</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">drawString()
   175</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">drejninger
   185</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">drevbogstaver
   252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">DriverManager
   284</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>E</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Eclipse
   26</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">egenskaber
   198</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">eksekverbare
  jar-filer  152</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">eksplicit
  typekonvertering  48, 56, 140</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">eksponentiel
  notation  244</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">elementtype
   82, 93</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">equals()
   76, 95, 139</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">er-en-relation
   125, 133, 145, 309</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Error
   239</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">esperanto-dansk-ordbog
   98</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">etikette
   199</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Event
   220</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">eventyrfort&aelig;lling
   82</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Exception
   238</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">executeQuery()
   285</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">extends
   124</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>F</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FalskTerning
   124, 126</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fange
  undtagelser  233</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">farve
   175</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fejl
   50</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fejlmeddelelse
   51</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Felt
  (matadorspil)  132, 133, 293</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">File
   252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FilenameFilter
   298</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FileNotFoundException
   233</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FileReader
   243, 248</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FileSystem.listRoots()
   252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FileWriter
   242</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">filh&aring;ndtering
   252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">filtrering
  af filnavne  298</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">filtreringsklasser
   249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">final
   148, 293</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">finally
   240</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fjerninterface
   278</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">flerdimensionale
  arrays  171</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">flertr&aring;det
  programmering  264</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">float
   55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FlowLayout
   201, 203</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">flueben
   198</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">flush()
   254</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FocusListener
   226</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Font
   176</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">for-l&oslash;kken
   45, 82</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">forberedt
  SQL  289</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">forbinde
  til en port  254</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">forgrundsfarve
   177, 198</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">formateringsstreng
   58</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">formelberegning
   162</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">formen
  af en klasse  117</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">forpligtende
  SQL  288</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">for&aelig;ldreklasse
   125</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fraktaler
   164</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Frame
   177, 202</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">fremviser
   188</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">FTP
   258, 259</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>G</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Gade
  (matadorspil)  135, 144</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">GeneralPath
   185</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getConnection()
   284</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">getTime()
   92</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">grafikbuffer
   184, 207</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">grafisk
  brugergr&aelig;nseflade  194, 220</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">grafisk
  vindue  174</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">grafiske
  komponenter  194</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Graphics
   175</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Graphics2D
   185</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">GridBagConstraints
   205</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">GridBagLayout
   204</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Grund
  (matadorspil)  143</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">grupper
  af klasser  150</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">GUI
   194</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">GZIP-filtreringsklasser
   250</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm; ">
  <FONT FACE="Helvetica, sans-serif"><B>H</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">har-relation
   108, 114, 122, 134, 145, 309</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HashMap
   97</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Helle
  (matadorspil)  133</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">heltal
   33, 55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">heltalsdivision
   56</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">hexadecimale
  talsystem  244</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">hjem
   252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">hjemmesider
   188</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTML-dokument
   188</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">HTTP-tjeneste
   254</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">h&aelig;ndelser
   220</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>I</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">if
   40</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">if-else
   41</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ild
   94</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Image
   176</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">implementere
  interface  210, 217</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">implicit
  typekonvertering  49, 55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">import
   150</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">import
  af klasser  72</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indexOf()
   76</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indkapsling
   103, 285, 295</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indlejrede
  l&oslash;kker  46</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indl&aelig;sning
  fra tastatur  234</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Indl&aelig;sning
  fra tastaturet  40, 59, 234, 244</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indre
  klasser  295</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indrykning
   42</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">indtastningsfelt
   199</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">init()
   190</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">initComponents()
   195</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">initialisering
  uden for konstrukt&oslash;r  147</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">InputStream
   247</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">InputStreamReader
   249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">insert()
   94</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">insertElementAt()
   81, 93</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Insets
   174, 177, 205</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">instruktioner
   31</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">int
   33, 55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Integer.parseInt()
   157, 244</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">interaktive
  programmer  196</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">interface
   210</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">InterruptedException
   265</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">IOException
   233</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ItemListener
   226</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>J</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">J2SE
   27</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">jar-filer
   152</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Java
  Studio Creator  25</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Java-arkiver
   152</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">java.applet
   150, 188</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">java.awt
   72, 150, 174</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">java.io
   150, 247</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">java.lang
   150</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">java.net
   150, 255</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">java.rmi
   150, 278, 282</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">java.sql
   150, 285</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">java.text
   150</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">java.util
   81, 150</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Java2D
   184</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">javac
   32</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">javadokumentationen
   87</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">javax.swing
   150, 207</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">jbInit()
   195</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JBuilder
   23</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JDBC
   284</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JDeveloper
   24</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JDK
   27</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JDK
  1.5  41, 82, 96</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">JDK1.5
   58</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>K</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kaste
  undtagelser  239</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">KeyListener
   225, 226</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kildetekst
   31</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">klassediagram
   114, 132, 145, 309</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">klassemetode
   60</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">klasser
   68, 87, 116</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">klassevariabler
  og -metoder  156, 160</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">klipning
   175</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kollaborationsdiagrammer
   308</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kommandolinie-parametre
   168</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kommatal
   35, 55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kommentarer
   30, 53</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">komponenter
   194</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">komprimering
   250</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">konstrukt&oslash;r
   105</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">konstrukt&oslash;r
  i underklasse  141, 143</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">konstrukt&oslash;rer
   72, 116, 148</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Konto
   122</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">koordinater
   174</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kopiere
  en fil  246</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Kurvetegning
   178</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">kvadratrod
   37</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">k&oslash;retidsfejl
   51</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>L</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Label
   199</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">layout
   194</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">layout-manager
   203</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">length()
   76</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">letv&aelig;gtkomponenter
   207</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">LineNumber-filtreringsklasser
   249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">line&aelig;r
  transformation  185</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">linieskift
   91</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Linjelytter
   228</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Linjetegning
   221, 223</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">LinjetegningAnonym
   299</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">LinjetegningIndre
   296</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">List
   200</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">liste
  af objekter  80</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">logisk
  variabel  38</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">logiske
  fejl  50</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">logiske
  udtryk  40, 57, 62</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">lokale
  klasser  297</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">lokale
  variabler  101, 156, 158</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">long
   55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">lukke
  vindue  174, 227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">LukProgram
   227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">lytte
  p&aring; en port  256</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">lytter
   220</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">l&aelig;sLinje()
   234</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">l&aelig;sTal()
   234</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">l&oslash;kker
   43</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>M</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">main()-metoden
   31, 101, 158, 168</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">manifest-fil
   152</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">matadorspil
   132</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">matematiske
  funktioner  37</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">mellemvariabel
   75</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">memappe
   252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">MenuBar
   206</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">metadata
   255, 290</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">metodehovede
   101, 118</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">metodekald
   38, 70, 71</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">metodekrop
   102</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">metoder
   38, 68, 73, 116, 160</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">metoder
  i vinduer  177</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">metoders
  returtype  74</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Microsoft
   22</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">modal
   202</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">MouseAdapter
   228</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">mouseClicked()
   227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">mouseDragged()
   223, 227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">MouseListener
   220, 227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">MouseMotionListener
   223, 227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">mouseMoved()
   223, 227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">mousePressed()
   227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">mouseReleased()
   220, 227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">multipel
  arv  217</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">multiplikation
   35</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Muselytter
   220</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">musens
  udseende  177</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>N</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">navngivne
  l&oslash;kker  64</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">navngivningsregler
   55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">nedarving
   217</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">nedarvning
   124</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">nedt&aelig;lling
   63</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">NetBeans
   25</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">netl&aelig;ser
   188</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">new-operatoren
   69</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">next()
   285</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">NOT
   57</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">notify()
   270</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">NotSerializableException
   273</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">NSidetTerning
   112</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">null
   72, 134, 231</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">null-layout
   203</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">NullPointerException
   231</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">nulpunkt
   174</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">n&oslash;gle
   97</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">n&oslash;gleindekserede
  tabeller  97</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">n&oslash;gleordet
  static  156</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">n&oslash;gleordet
  super  126, 141</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">n&oslash;gleordet
  this  111</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>O</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Object
  (stamklasse)  139</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ObjectOutputStream
   249, 272</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">objekter
   68, 87</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">objektorienteret
  analyse  305</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">objektorienteret
  design  308</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">objektreferencer
   159</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">objektrelationer
   108, 122</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">objektvariabler
   70, 100, 117, 156, 160</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ODBC
   284, 289</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">OOAD
   304</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">open
  source  28</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">operatorer
   56</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">oprette
  objekt  69</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">optimering
   95, 246, 288</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">opt&aelig;lling
   63</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">OR
   57</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Oracle
   24, 284</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">OutputStream
   247</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">OutputStreamWriter
   249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">overs&aelig;tte
   32</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">overs&aelig;tterfejl
   50</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>P</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">paint()
   174</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">pakker
   72, 150</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Panel
   202</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">parametervariabler
   158</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">parametre
   71, 87, 118, 158</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">pause
   137</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Person
   114</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Piped-filtreringsklasser
   249</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">platformuafh&aelig;ngig
   21, 32, 207</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">platformuafh&aelig;ngige
  filnavne  252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Point
   69, 88</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Polygon
   176</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">polymorfe
  variabler  128</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">polymorfi
   129, 132, 138, 169, 214</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">prepareCall()
   289</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">PreparedStatement
   289</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">prepareStatement()
   289</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">primtal
   60</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">printf()
   58</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">printStackTrace()
   232</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">PrintWriter
   242</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">prioritet
   270</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">private
   103, 154</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">protected
   148, 154</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">public
   103, 154</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Pushback-filtreringsklasser
   249</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>R</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">radioknapper
   198</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">RandomAccessFile
   252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">readLine()
   255</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">readObject()
   272, 276</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Rectangle
   72, 89</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Rederi
  (matadorspil)  134, 144</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">reference-typekonvertering
   131</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">referencer
   159</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">regneudtryk
   34</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">rekursion
   161, 252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">relationer
  mellem objekter  108, 122</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Remote
   278</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">removeElementAt()
   81</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">repaint()
   177, 182</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">replace
  ()  76</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">restdivision
   56</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ResultSet
   285, 290</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ResultSetMetaData
   290</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">return
   102, 116</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">returtype
   74, 87, 101, 118</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">reverse()
   94</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">RMI
   278</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">rmiregistry
   279</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">rollback()
   288</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">rotation
   185</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">run()
   264</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Runnable
   264</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">r&aelig;kke
  af data  166</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>S</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sammenligning
  af strenge  79</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sammenligningsoperatorer
   40, 57</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sammens&aelig;tte
  strenge  34</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Scanner
   40, 244, 245</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">semaforer
   270</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">serialisering
   272, 278</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Serializable
   273</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ServerSocket
   256</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Shape
   185</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">short
   55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sikkerhed
   192</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">simple
  typer  55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sinus
   37</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">skaleringer
   185</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">skilletegn
   158</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">skjule
  variabler/metoder  103</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">skrifttype
   177, 198</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">skrive
  til en tekstfil  242</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sleep()
   137, 265</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SnakkesagligPerson
   264</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Socket
   254</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SocketException
   233</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sortering
   214</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">specialtegn
  i strenge  91</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Spiller
  (matadorspil)  136</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sprogfejl
   50</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SQL
   284</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">SQLException
   233, 284</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">stakspor
   232</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">stamklasse
   125</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">stamklassen
  Object  139</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">standardbiblioteket
   87, 150, 157</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">standardkonstrukt&oslash;r
   106, 116, 142</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">standardp
   150</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Start
  (matadorspil)  133</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">start()
   190, 264</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Statement
   284</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">static
   156</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">statistik
   167, 245</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">statusfelt
   189</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sti-separatortegn
   252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">stop()
   190</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">stoppe
  grafisk program  174</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">stoppe
  programudf&oslash;relsen  158</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">strenge
   76</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">String
   76, 90</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">StringBuffer
   94</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">StringBuilder
   94</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">StringReader
   248</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">subklasse
   125</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">subrutiner
   158</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">substring()
   76</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">super
   126, 141, 144</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">superklasse
   125</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">sv&aelig;rv&aelig;gtskomponenter
   207</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Swing-komponenter
   207</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">switch
   65</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">synchronized
   269</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">synlighed
  af metoder/variabler  154</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">syntaksfejl
   50</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">System.exit()
   158</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">System.out
   157, 244</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>T</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tabulator
   91</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">talsystem
   244</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Tastatur
   40, 59, 234</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tastetryk
   225</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Tegnbar
   210</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tegne
  grafik  175</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tegneomr&aring;de
   200</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tekstdata
   248</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tekststrenge
   76</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Terning
   107</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">TextArea
   199</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">TextField
   199</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">TextListener
   227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">this
   111, 122, 137, 148</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Thread
   264</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Thread.sleep()
   137, 265</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">throw
   239</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Throwable
   239</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">throws
   233</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tildeling
   33</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tilsides&aelig;tte
  variabler  148</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">titel
  p&aring; vindue  177</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tjeneste
   254</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">TogetherJ
   309</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">toLowerCase()
   76</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">toString()
   139</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">toUpperCase()
   76</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">transaktion
   288</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">transformation
   185</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">transient
   273</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">trappeudj&aelig;vning
   184</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">trim()
   90</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">trinvis
  gennemgang  47</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">try-catch-blok
   231, 237</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">tr&aring;de
   264, 300</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">typekonvertering
   48, 55, 131, 140</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">t&aelig;llevariabel
   44</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>U</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">udbygge
  en klasse  124</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">udj&aelig;vnede
  farveovergange  184</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">uendelige
  l&oslash;kker  47</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">uforanderlig
   77</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">UML-notationen
   69</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">UML-udviklingsv&aelig;rkt&oslash;j
   309</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">underklasse
   125</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">undtagelser
   51, 230</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Unified
  Modelling Language  69</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">unikode
   91</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">UnknownHostException
   233</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">unreported
  exception  233</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">update()
   183</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">URL
   189</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">URL-klassen
   257</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">user.dir
   252</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">user.home
   252</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>V</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">valglister
   198</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">variabel-overskygning
   148</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">variabler
   33</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">variabler
  i interface  218</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">vente
    137</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">vindue
   174</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">virkefelt
   158</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">virtuel
  maskine  21</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">vognretur
   91</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">void
   87, 116</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">vridninger
   185</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">v&aelig;rditypekonvertering
   48, 55</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">v&aelig;rtsmaskine
   254</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>W</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">wait()
   270</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">webserver
   256, 266</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">while-l&oslash;kken
   43</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Window
   202</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">WindowListener
   227</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">writeObject()
   272, 276</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>Y</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Yatzyspil
   305</FONT></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">ydre
  klasse  295</FONT></FONT></P>
  <P STYLE="margin-top: 0.15cm; margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><B>Z</B></FONT></P>
  <P STYLE="margin-bottom: 0cm"><FONT FACE="Helvetica, sans-serif"><FONT SIZE=1 STYLE="font-size: 8pt">Zip-filtreringsklasser
   249</FONT></FONT></P>
</MULTICOL>



<P CLASS="western"><B>&AElig;ndringer i tredje udgave</B></P>
<P CLASS="western">I de sidste &aring;r har jeg samlet p&aring;
rettelser, kommentarer og forslag til bogen og derudover selv
undervist i den. Rettelserne og forbedringerne er n&aelig;sten alle
f&oslash;rt ind i tredje udgave</P>
<P CLASS="western">Selvom der er kommet meget stof til, er sidetallet
ikke &oslash;get. I stedet er de eksisterende sider blevet bedre
udnyttet.</P>

<P CLASS="western"><A CLASS="western" HREF="#2.2.2.Stor opbakning|outline">1.2.2
Stor opbakning</A></P>
<P CLASS="western"><A CLASS="western" HREF="#2.3.Programmeringsv&aelig;rkt&oslash;jer til Java|outline">1.3
Programmeringsv&aelig;rkt&oslash;jer til Java</A></P>
<P CLASS="western"><A CLASS="western" HREF="#3.3.1.if-else|outline">2.3.1
if-else</A></P>
<P CLASS="western"><A CLASS="western" HREF="#4.4.6.Opgaver|outline">3.4.6
Opgaver</A></P>
<P CLASS="western"><A CLASS="western" HREF="#4.6.2.Opdeling af strenge (klassen StringTokenizer)|outline">3.6.2
Opdeling af strenge (klassen StringTokenizer)</A></P>
<P CLASS="western"><A CLASS="western" HREF="#4.9.3.Klassen String|outline">3.9.3
Klassen String</A></P>
<P CLASS="western"><A CLASS="western" HREF="#4.9.7.Klassen ArrayList|outline">3.9.7
Klassen ArrayList</A></P>
<P CLASS="western"><A CLASS="western" HREF="#4.10.2.N&oslash;gleindekserede tabeller (klassen HashMap)|outline">3.10.2
N&oslash;gleindekserede tabeller (klassen HashMap)</A></P>
<P CLASS="western"><A CLASS="western" HREF="#6.2.4.Hvilken vej er en variabel polymorf ?|outline">5.2.4
Hvilken vej er en variabel polymorf ? </A>
</P>
<P CLASS="western"><A CLASS="western" HREF="#6.5.1.Konsekvenser|outline">5.5.1
Konsekvenser</A></P>
<P CLASS="western"><A CLASS="western" HREF="#7.9.3.Indkapsling med pakker|outline">6.9.3
Indkapsling med pakker</A></P>
<P CLASS="western"><A CLASS="western" HREF="#10.3.1.Opgave: Grafisk Matador-spil|outline">9.3.1
Opgave: Grafisk Matador-spil</A></P>
<P CLASS="western"><A CLASS="western" HREF="#10.4.1.Simple animationer|outline">9.4.1
Simple animationer</A></P>
<P CLASS="western"><A CLASS="western" HREF="#11.5.3.Begr&aelig;nsninger i &aelig;ldre netl&aelig;sere|outline">10.5.3
Begr&aelig;nsninger i &aelig;ldre netl&aelig;sere</A></P>
<P CLASS="western"><A CLASS="western" HREF="#12.4.5.Dialog|outline">11.4.5
Dialog</A> og mere??</P>
<P CLASS="western"><A CLASS="western" HREF="#12.1.Generering med et v&aelig;rkt&oslash;j|outline">11.1
Generering med et v&aelig;rkt&oslash;j</A></P>
<P CLASS="western"><A CLASS="western" HREF="#16.3.Indl&aelig;sning fra tastatur|outline">15.3
Indl&aelig;sning fra tastatur</A></P>
<P CLASS="western"><A CLASS="western" HREF="#16.4.Analysering af tekstdata|outline">15.4
Analysering af tekstdata</A></P>
<P CLASS="western"><A CLASS="western" HREF="#16.4.1.Konvertere strenge til tal|outline">15.4.1
Konvertere strenge til tal</A></P>
<P CLASS="western"><A CLASS="western" HREF="#16.4.2.Samlet eksempel: Statistik|outline">15.4.2
Samlet eksempel: Statistik</A></P>
<P CLASS="western"><A CLASS="western" HREF="#18.4.Avanceret|outline">17.4
Avanceret</A></P>
<P CLASS="western"><A CLASS="western" HREF="#23.2.2.Brugssituationer|outline">22.2.2
Brugssituationer</A></P>
<P CLASS="western"><A CLASS="western" HREF="#23.3.1.Design af klasser|outline">22.3.1
Design af klasser</A></P>

<P CLASS="western">introducere og snakke om ny for-l&oslash;kke et
sted!</P>

<P CLASS="western">else-if beskrevet (OK)</P>
<P CLASS="western">ArrayList i stedet for Vector, HashMap i stedet
for Hashtable, Iterator i stedet for Enumeration (OK?)</P>
<P CLASS="western">Brug at generics (f.eks. ArrayList&lt;String&gt;,
dvs ArrayList der KUN kan indeholde strenge) (OK?)</P>
<UL>
  <LI><P CLASS="western">ny for-l&oslash;kke (foreach)</P>
  <LI><P CLASS="western">autoboxing (automatisk konvertering af f.eks.
  int til/fra Integer-objekt)</P>
  <LI><P CLASS="western">Animationer sker fra main-metodens tr&aring;d
  ( repaint(1000) er endelig taget v&aelig;k!! )</P>
  <LI><P CLASS="western">Behold AWT (mere begyndervenligt end Swing)?</P>
  <LI><P CLASS="western">Afsnit om og supplerende brug af BlueJ</P>
  <LI><P CLASS="western">Matador-eksempel revideret (OK)</P>
  <LI><P CLASS="western">String-klassen har en del nye metoder, der
  g&oslash;r opgaverne om String fjollede</P>
  <LI><P CLASS="western">System.out.printf() overtager al tal- og
  datoformatering</P>
  <LI><P CLASS="western">java.util.Scanner g&oslash;r Tastatur-klassen
  overfl&oslash;dig</P>
  <LI><P CLASS="western">Afsnit om udviklingsv&aelig;rkt&oslash;jer
  opdateret</P>
  <LI><P CLASS="western">UML-diagrammer strammet op</P>
</UL>

<UL>
  <LI><P CLASS="western">+ Generiske klasser (generics/parametriserede
  typer)</P>
  <UL>
    <LI><P CLASS="western">St&aelig;rkere typesikkerhed. Eks.:
    ArrayList af strenge: 
    </P>
    <LI><P CLASS="western">ArrayList&lt;String&gt; sl = new
    ArrayList&lt;String&gt;();</P>
  </UL>
  <LI><P CLASS="western">+ Nemmere for-l&oslash;kke</P>
  <UL>
    <LI><P CLASS="western">Kan genneml&oslash;be enhver datastruktur
    (bruger skjult Iterator p&aring; Collections-klasser og
    t&aelig;llevariabel p&aring; almindelige arrays)</P>
    <LI><P CLASS="western">for(String s : sl) { System.out.println(s);
    }</P>
  </UL>
  <LI><P CLASS="western">+ Automatisk konvertering mellem simpel type
  og objekt</P>
  <UL>
    <LI><P CLASS="western">Map&lt;String, Integer&gt; navnTilCPR = new
    HashMap&lt;String, Integer&gt;();</P>
    <LI><P CLASS="western">navnTilCPR.put(&quot;Jacob Nordfalk&quot;,
    010171); // boxing af int 010171</P>
    <LI><P CLASS="western">int cpr = navnTilCPR.get(&quot;Jacob
    Nordfalk&quot;); // unboxing af Integer 010171</P>
  </UL>
  <LI><P CLASS="western">% Typesikre opremsninger (typesafe enums)</P>
  <UL>
    <LI><P CLASS="western">public enum MainMenu {FILE, EDIT, FORMAT,
    VIEW};</P>
  </UL>
  <LI><P CLASS="western">+/- Variabelt antal argumenter til en metode
  (array af arg)</P>
  <LI><P CLASS="western">- Import af klassemetoder og -variabler
  (static import)</P>
  <UL>
    <LI><P CLASS="western">import static java.lang.Math.*;             
    ...    x = 2*PI; y = sin(x); ...</P>
  </UL>
  <LI><P CLASS="western">- Metadata (Annotations)</P>
</UL>


<P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm"> den
sidste printf-s&aelig;tning formateres et Date-objekt (dato og tid).
Her er nogle af typerne:</P>
<UL>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">%tA
  giver dagens fulde navn (f.eks. onsdag), %ta giver en 3-bogstavs
  forkortelse</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">%tB
  giver m&aring;nedens fulde navn (f.eks. januar), %tb giver en
  3-bogstavs forkortelse</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">%te
  giver dagen i m&aring;neden, %td evt. med foranstillet 0.</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">%tY
  giver &aring;ret med 4 cifre, %ty med 2 cifre</P>
  <LI><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">%tt
  giver klokkel&aelig;t p&aring; dagen</P>
</UL>
<P CLASS="western">xxx flere?</P>
<P CLASS="western">xxx n&aelig;vn om String.format()</P>
<P CLASS="western">xxx d</P>
<P CLASS="western">OOAD</P>
<P CLASS="western">xxx snak om brugssituationer skrevet p&aring;
listeform</P>
<P CLASS="western">xxx snak om ansvarsomr&aring;der</P>
<P CLASS="western">xxx Husk at s&aelig;tte linjenummerering i
typografi &quot;kode m linienr.&quot; f&oslash;r ny udgave udgives 
</P>
<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>En
  helt anden arbejdsform, der pr&oslash;ver at g&aring; med den
  umiddelbare impuls til at programmere med det samme, er
  <I>ekstremprogrammering</I>. I denne form beskriver man f&oslash;rst
  kodens &oslash;nskede opf&oslash;rsel i form af testtilf&aelig;lde,
  der kan afpr&oslash;ves automatisk gennem hele forl&oslash;bet. S&aring;
  programmerer man <SPAN STYLE="font-style: normal">to og to</SPAN>
  foran samme tastatur, indtil testene er opfyldt. Til sidst l&aelig;gger
  man sig fast p&aring; et fornuftigt design og omstrukturerer
  programmet til at passe med det valgte design.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel21.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel23.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (82% af vrket).
</font>
<br>
nsker du at se de sidste 18% af dette vrk (199974 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
